define(['models/singleton-collection'], function(Collection) {
    'use strict';

    return Collection.extend({
        resourceName: 'disabled-features',

        parse: function(response, options) {
            if (response && response.disabledFeatures) {
            // when: there is a response of disabledFeatures
            // then: we convert the response into an array of objects with the id of the feature
                return response.disabledFeatures.map(function(feature) {
                    return {id: feature};
                });
            }
            return null;

        },
    });
});
